%88 Phased series fed patch antenna array at 28 GHz for 5G mobile base station antennas

%REFERENCES
%[1] M. K. Ishfaq, T. A. Rahman, Y. Yamada, and K. Sakakibara, 8x8 Phased Series Fed Patch Antenna Array at 28 GHz for 5G Mobile Base Station Antennas,
%2017 IEEE-APS Topical Conference on Antennas and Propagation in Wireless Communications (APWC), pp. 160-162, 2017.
%https://ieeexplore.ieee.org/document/8062268

clc
clear all

pr = new_project();

%Model parameters
Wp		= 3.539;		%length and width of the each single patch element
Lc		= 3.539;		%length of interconnecting transmission line of adjacent array elements
Wc		= 0.494;		%width of interconnecting transmission line of adjacent array elements
Wf		= 0.720;		%width of the feeding microstrip line
Wm		= 2.727;		%width of matching inset feeding at the last array element
Lm		= 0.6269;		%length of matching inset feeding at the last array element
d		= Wp/2+3.55;	%inter-element spacing
h 		= 0.254;	    %substrate height
Larr	= 55.3;		    %length of antenna array
Warr	= 41;			%width of antenna array
a = 2;

%Create patches and transmission lines connecting patches
for n = 1:7
	X_origin = n*Wp+n*Lc;
	patch = pr.create_plate([X_origin, 0, 0], [1, 0, 0], [0, 1, 0], Wp, Wp);
	line = pr.create_plate([X_origin+Wp, (Wp-Wc)/2, 0], [1, 0, 0], [0, 1, 0], Lc, Wc);
end

%Create microstrip line for antenna feeding
microstrip = pr.create_plate([Wp+Lc, (Wp-Wf)/2, 0], [-1, 0, 0], [0, 1, 0], Wf, Wf);

%Create port segment
port = pr.create_line([Wp+Lc-Wf, Wp/2, 0], [Wp+Lc-Wf, Wp/2, -h]);

%Create connector to last patch
connector_plate = pr.create_plate([7*Wp+7*Lc+Wp+Lc, (Wp-Wc)/2, 0], [1, 0, 0], [0, 1, 0], Lm, Wc);

point1 = [7*Wp+7*Lc+Wp+Lc,	  (Wp-Wm)/2-Lm,	   0];
point2 = [7*Wp+7*Lc+Wp+Lc,	  (Wp-Wm)/2,	   0];
point3 = [7*Wp+7*Lc+Wp+Lc+Lm, (Wp-Wm)/2,	   0];
point4 = [7*Wp+7*Lc+Wp+Lc+Lm, (Wp-Wm)/2+Wm,	   0];
point5 = [7*Wp+7*Lc+Wp+Lc,	  (Wp-Wm)/2+Wm,	   0];
point6 = [7*Wp+7*Lc+Wp+Lc,	  (Wp-Wm)/2+Wm+Lm, 0];
point7 = [7*Wp+7*Lc+Wp+Lc+Wp, (Wp-Wm)/2+Wm+Lm, 0];
point8 = [7*Wp+7*Lc+Wp+Lc+Wp, (Wp-Wm)/2-Lm,	   0];
point9 = [7*Wp+7*Lc+Wp+Lc,	  (Wp-Wm)/2-Lm,	   0];

points = [point1 point2 point3 point4 point5 point6 point7 point8 point9];

last_patch = pr.create_polyline(points(1:3:end), points(2:3:end), points(3:3:end));
boundary = pr.create_boundary(last_patch);
pr.delete(last_patch);

%Unite all bodies from 1st array
bodies = pr.bodies();
array_1 = pr.union(bodies);

%Generate 8x8 patch array
for i=1:7
	array_2 = pr.duplicate(array_1);
	pr.translate([0, 1, 0], i*d, array_2);
end

%Create antenna ground
gnd = pr.create_plate([Wp+Lc-Wf, -a/2, -h], [1, 0, 0], [0, 1, 0], Larr, Warr+a);

%Unite all geometry objects
model = pr.bodies();
final_model = pr.union(model);

pr.bestFit
pr.restorePosition
